#include <string.h>
#include <stdlib.h>
#include "msh.h"
#include "primitiv.h"

/* typical actions given here as example; add your own... */

void Dup(void){Pushlong(1l);Pick();}

void Swap(void){Pushlong(2l);Roll();}

void Equal(void)
{ refobj s=Pop(),t=Pop();
  if(strcmp(s->val,t->val))Pushbool(FALSE);
  else Push(t);
  Free(t);Free(s);
}

void Not(void){Pushbool(!Popbool());}

void Sum(void){Pushlong(Poplong()+Poplong());}

void Minus(void){long a=Poplong();Pushlong(Poplong()-a);}

void Times(void){Pushlong(Poplong()*Poplong());}

void Divide(void){long a=Poplong();
 if(a==0)efns(WARNING_,"division by 0");else Pushlong(Poplong()/a);}

void Lt(void){long a=Poplong();Pushbool(Poplong()<a);}

void Le(void){long a=Poplong();Pushbool(Poplong()<=a);}

void Ge(void){long a=Poplong();Pushbool(Poplong()>=a);}

void Gt(void){long a=Poplong();Pushbool(Poplong()>a);}

void Length(void){refobj s=Pop();Pushlong(strlen(s->val));Free(s);}

void Substring(void)
{ long b=Poplong(),a=Poplong(); refobj s=Pop();
  int len=strlen(s->val);
  if(a<1 || b<1 || b<a || a>len || b>len)
   efns(WARNING_," substring: illegal range");
  else
  { char save=s->val[b];s->val[b]=0;Pushstring(s->val+a-1);s->val[b]=save;}
  Free(s);
}

void Cat(void)
{refobj s=Pop(),t=Pop(),
	r=(refobj)malloc(sizeof(int)+1+strlen(s->val)+strlen(t->val));
 testalloc(r);
 strcpy(stpcpy(r->val,t->val),s->val);r->rc=0;Push(r);
 Free(t);Free(s);
}

void CutFirst(void)
{ refobj s=Pop(),t=Pop();
  char *c=strstr(t->val,s->val);
  if(NULL==c){Push(t);Pushbool(FALSE);}
  else{char save=*c;*c=0;Pushstring(t->val);*c=save;
       c+=strlen(s->val);Pushstring(c);}
  Free(s);Free(t);
}

void CutLast(void)
{ refobj s=Pop(),t=Pop();
  char *c=NULL,*d;
  for(d=t->val;(d=strstr(d,s->val)) && *d;d++)
    c=d;
  if(NULL==c){Push(t);Pushbool(FALSE);}
  else{char save=*c;*c=0;Pushstring(t->val);*c=save;
       c+=strlen(s->val);Pushstring(c);}
  Free(s);Free(t);
}

#include <io.h>
#include <dos.h>
#include <errno.h>
void Unlink(void)
{ refobj s=Pop();
  if(-1==unlink(s->val) && errno==EACCES)
  { Pushstring("delete read-only file ");Pushstring(s->val);Cat();Ok();
    if(Popbool()){_dos_setfileattr(s->val,0);unlink(s->val);}
  }
  Free(s);
}

void Rename(void)
{ refobj s=Pop(),t=Pop();
  if(rename(t->val,s->val))Pushbool(FALSE);
  else Push(t);
  Free(s);Free(t);
}

#include <fcntl.h>
void Read(void)
{ refobj name=Pop();
  int handle=open(name->val,O_RDONLY|O_TEXT);
  if(-1==handle)efns(WARNING_|FILE_,name->val);
  else
  { long flen=filelength(handle);
    if(flen>65534u-sizeof(int))
      efns(WARNING_,"file `%s' too big: %ld bytes",name->val,flen);
    else
    { refobj s=(refobj)malloc(sizeof(int)+1+(unsigned)flen);
      testalloc(s);s->rc=0;
      if(-1==(flen=read(handle,s->val,(unsigned)flen)))
      { efns(WARNING_|FILE_,name->val);Free(s);}
      else { s->val[flen]=0; Push(s);}
    }
    close(handle);
  }
  Free(name);
}

#include <sys/stat.h>
void Write(void)
{ refobj name=Pop(),s=Pop();
  int handle=open(name->val,O_WRONLY|O_CREAT|O_APPEND|O_TEXT,S_IWRITE|S_IREAD);
  if(-1==handle)efns(WARNING_|FILE_,name->val);
  else
  { if(strlen(s->val)!=write(handle,s->val,strlen(s->val)))
	 efns(WARNING_|FILE_,name->val);
    close(handle);
  }
  Free(name);Free(s);
}

void Copy(void)
{ refobj dest=Pop(),src=Pop();int desth,srch;bool res=TRUE;
  unsigned attrs,datep,timep;
  char *buf;unsigned sz=65528u,n;
  desth=open(dest->val,O_WRONLY|O_CREAT|O_BINARY|O_TRUNC,S_IWRITE|S_IREAD);
  if(-1==desth)efns(WARNING_|FILE_,dest->val);
  srch=open(src->val,O_RDONLY|O_BINARY);
  if(-1==srch)efns(WARNING_|FILE_,src->val);
  _dos_getftime(srch,&datep,&timep);
  while(NULL==(buf=malloc(sz)) && sz>4000)sz>>=1;
  testalloc(buf);
  while(n=read(srch,buf,sz))
     if(n==(unsigned)-1 || write(desth,buf,n)!=n)
     { if(n==(unsigned)-1)efns(WARNING_|FILE_,"while copying");
       else efns(WARNING_,"target disk full while copying");
       res=FALSE;
       break;
     }
  free(buf);close(srch);close(desth);
  if(res)
  { _open(dest->val,O_WRONLY);_dos_setftime(desth,datep,timep);_close(desth);
    _dos_getfileattr(src->val,&attrs);_dos_setfileattr(dest->val,attrs);
    Push(dest);
  }
  else {unlink(dest->val);Pushbool(FALSE);}
  Free(src);Free(dest);
}

void Tempname(void)
{ refobj s;
  Pushstring("MSXXXXXX");Cat();s=Pop();
  mktemp(s->val);
  Push(s);
}

void Diskstats(void)
{ struct diskfree_t s;refobj d=Pop();strupr(d->val);
  _dos_getdiskfree(d->val[0]?d->val[0]-'A'+1:0,&s);Free(d);
  Pushlong((long)s.sectors_per_cluster*s.bytes_per_sector);
  Pushlong((long)s.avail_clusters);
  Pushlong((long)s.total_clusters);
}
